<?php if(isset($pageConfigs)): ?>
    <?php if(count($pageConfigs) > 0): ?>
        <?php $__currentLoopData = $pageConfigs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e(Config::set('custom.custom.'.$config, $val)); ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php endif; ?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title'); ?> - Vuexy Vuejs, HTML & Laravel Admin Dashboard Template</title>
        <link rel="shortcut icon" type="image/x-icon" href="images/logo/favicon.ico">

        
        <?php echo $__env->make('panels/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->yieldContent('mystyle'); ?>

    </head>

    
    <?php
    $configData = Helper::applClasses();
    ?>

    <body class="vertical-layout vertical-menu-modern 2-columns <?php echo e($configData['blankPageClass']); ?> <?php echo e($configData['bodyClass']); ?> <?php echo e($configData['theme']); ?> <?php echo e($configData['navbarType']); ?> <?php echo e($configData['sidebarClass']); ?> <?php echo e($configData['footerType']); ?>  footer-light" data-menu="vertical-menu-modern" data-col="2-columns">
        
        <?php echo $__env->make('panels.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- BEGIN: Content-->
        <div class="app-content content">
            <!-- BEGIN: Header-->
            <div class="content-overlay"></div>
            <div class="header-navbar-shadow"></div>

            
            <?php echo $__env->make('panels.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="content-wrapper">
                
                <?php if($configData['pageHeader'] == true): ?>
                    <?php echo $__env->make('panels.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <div class="<?php echo e($configData['sidebarPositionClass']); ?>">
                    <div class="sidebar">
                        
                        <?php echo $__env->yieldContent('content-sidebar'); ?>
                    </div>
                </div>
                <div class="<?php echo e($configData['contentsidebarClass']); ?>">
                    <div class="content-body">
                        
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: Content-->

        <?php if($configData['blankPage'] == false): ?>
            <?php echo $__env->make('pages/customizer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('pages/buy-now', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <div class="sidenav-overlay"></div>
        <div class="drag-target"></div>

        
        <?php echo $__env->make('panels/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php echo $__env->make('panels/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php echo $__env->yieldContent('myscript'); ?>

    </body>
</html>

<?php /**PATH C:\xampp\htdocs\vuesax-bootstrap-laravel-admin-template\resources\views/layouts/detachedLayoutMaster.blade.php ENDPATH**/ ?>