<?php $__env->startSection('title', 'List View'); ?>

<?php $__env->startSection('vendor-style'); ?>
        
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/datatables.min.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/file-uploaders/dropzone.min.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/extensions/dataTables.checkboxes.css'))); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mystyle'); ?>
        
        <link rel="stylesheet" href="<?php echo e(asset(mix('css/plugins/file-uploaders/dropzone.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('css/pages/data-list-view.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section id="data-list-view" class="data-list-view-header">
    <div class="action-btns d-none">
      <div class="btn-dropdown mr-1 mb-1">
        <div class="btn-group dropdown actions-dropodown">
          <button type="button" class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Actions
          </button>
          <div class="dropdown-menu">
            <a class="dropdown-item" href="#">Delete</a>
            <a class="dropdown-item" href="#">Print</a>
            <a class="dropdown-item" href="#">Archive</a>
            <a class="dropdown-item" href="#">Another Action</a>
          </div>
        </div>
      </div>
    </div>

    
    <div class="table-responsive">
      <table class="table data-list-view">
        <thead>
          <tr>
            <th></th>
            <th>NAME</th>
            <th>CATEGORY</th>
            <th>POPULARITY</th>
            <th>ORDER STATUS</th>
            <th>PRICE</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($product["order_status"] === 'delivered'): ?>
              <?php $color = "success" ?>
            <?php elseif($product["order_status"] === 'pending'): ?>
              <?php $color = "primary" ?>
            <?php elseif($product["order_status"] === 'on hold'): ?>
              <?php $color = "warning" ?>
            <?php elseif($product["order_status"] === 'canceled'): ?>
              <?php $color = "danger" ?>
            <?php endif; ?>
            <?php 
              $arr = array('success', 'primary', 'info', 'warning', 'danger');
            ?>
            
            <tr>
              <td></td>
              <td class="product-name"><?php echo e($product["name"]); ?></td>
              <td class="product-category"><?php echo e($product["category"]); ?></td>
              <td>
                <div class="progress progress-bar-<?php echo e($arr[array_rand($arr)]); ?>">
                  <div class="progress-bar" role="progressbar" aria-valuenow="40" aria-valuemin="40" aria-valuemax="100"
                    style="width:<?php echo e($product["popularity"]); ?>%"></div>
                </div>
              </td>
              <td>
                <div class="chip chip-<?php echo e($color); ?>">
                  <div class="chip-body">
                    <div class="chip-text"><?php echo e($product["order_status"]); ?></div>
                  </div>
                </div>
              </td>
              <td class="product-price"><?php echo e($product["price"]); ?></td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        
      </table>
    </div>
    

    
    <div class="add-new-data-sidebar">
      <div class="overlay-bg"></div>
      <div class="add-new-data">
        <form action="data-list-view" method="POST">
          <?php echo csrf_field(); ?>
          <div class="div mt-2 px-2 d-flex new-data-title justify-content-between">
            <div>
              <h4>ADD NEW DATA</h4>
            </div>
            <div class="hide-data-sidebar">
              <i class="feather icon-x"></i>
            </div>
          </div>
          <div class="data-items pb-3">
            <div class="data-fields px-2 mt-3">
              <div class="row">
                <div class="col-sm-12 data-field-col">
                  <label for="data-name">Name</label>
                  <input type="text" class="form-control" name="name" id="data-name">
                </div>
                <div class="col-sm-12 data-field-col">
                  <label for="data-category"> Category </label>
                  <select class="form-control" name="category" id="data-category">
                    <option>Audio</option>
                    <option>Computers</option>
                    <option>Fitness</option>
                    <option>Appliance</option>
                  </select>
                </div>
                <div class="col-sm-12 data-field-col">
                  <label for="data-status">Order Status</label>
                  <select class="form-control" id="data-status" name="order_status">
                    <option>Pending</option>
                    <option>Cancelled</option>
                    <option>Delivered</option>
                    <option>On Hold</option>
                  </select>
                </div>
                <div class="col-sm-12 data-field-col">
                  <label for="data-price">Price</label>
                  <input type="number" class="form-control" name="price" id="data-price">
                </div>
                <div class="col-sm-12 data-field-col">
                  <label for="data-popularity">Popularity</label>
                  <input type="number" class="form-control" name="popularity" id="data-popularity">
                </div>
                <div class="col-sm-12 data-field-col data-list-upload">
                  <div class="dropzone dropzone-area" action="#" id="dataListUpload" name="img">
                    <div class="dz-message">Upload Image</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="add-data-footer d-flex justify-content-around px-3 mt-2">
            <div class="add-data-btn">
              <input type="submit" class="btn btn-primary" value="Add Data">
            </div>
            <div class="cancel-data-btn">
              <input type="reset" class="btn btn-outline-danger" value="Cancel">
            </div>
          </div>
        </form>
      </div>
    </div>
    
  </section>
  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('vendor-script'); ?>

        <script src="<?php echo e(asset(mix('vendors/js/extensions/dropzone.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.buttons.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.bootstrap4.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/buttons.bootstrap.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.checkboxes.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('myscript'); ?>
        
        <script src="<?php echo e(asset(mix('js/scripts/ui/data-list-view.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\vuesax-bootstrap-laravel-admin-template\resources\views//pages/data-list-view.blade.php ENDPATH**/ ?>