<?php $__env->startSection('title', 'Quill Editor'); ?>

<?php $__env->startSection('vendor-style'); ?>
        <!-- vednor css files -->
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/editors/quill/katex.min.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/editors/quill/monokai-sublime.min.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/editors/quill/quill.snow.css'))); ?>">
        <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/editors/quill/quill.bubble.css'))); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Snow Editor start -->
<section class="snow-editor">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Snow Editor</h4>
        </div>
        <div class="card-content collapse show">
          <div class="card-body">
            <p>Snow is a clean, flat toolbar theme.</p>
            <div class="row">
              <div class="col-sm-12">
                <div id="snow-wrapper">
                  <div id="snow-container">
                    <div class="quill-toolbar">
                      <span class="ql-formats">
                        <select class="ql-header">
                          <option value="1">Heading</option>
                          <option value="2">Subheading</option>
                          <option selected>Normal</option>
                        </select>
                        <select class="ql-font">
                          <option selected>Sailec Light</option>
                          <option value="sofia">Sofia Pro</option>
                          <option value="slabo">Slabo 27px</option>
                          <option value="roboto">Roboto Slab</option>
                          <option value="inconsolata">Inconsolata</option>
                          <option value="ubuntu">Ubuntu Mono</option>
                        </select>
                      </span>
                      <span class="ql-formats">
                        <button class="ql-bold"></button>
                        <button class="ql-italic"></button>
                        <button class="ql-underline"></button>
                      </span>
                      <span class="ql-formats">
                        <button class="ql-list" value="ordered"></button>
                        <button class="ql-list" value="bullet"></button>
                      </span>
                      <span class="ql-formats">
                        <button class="ql-link"></button>
                        <button class="ql-image"></button>
                        <button class="ql-video"></button>
                      </span>
                      <span class="ql-formats">
                        <button class="ql-formula"></button>
                        <button class="ql-code-block"></button>
                      </span>
                      <span class="ql-formats">
                        <button class="ql-clean"></button>
                      </span>
                    </div>
                    <div class="editor">
                      <h1 class="ql-align-center">Quill Rich Text Editor</h1>
                      <p><br></p>
                      <p>Quill is a free, <a href="https://github.com/quilljs/quill/">open source</a> WYSIWYG editor
                        built for the modern web. With its <a href="http://quilljs.com/docs/modules/">modular
                          architecture</a> and expressive <a href="http://quilljs.com/docs/api/">API</a>, it is
                        completely customizable to fit any need.</p>
                      <p><br></p>
                      <iframe class="ql-video ql-align-center"
                        src="https://www.youtube.com/embed/QHH3iSeDBLo?showinfo=0" width="560" height="238"></iframe>
                      <p><br></p>
                      <p><br></p>
                      <h2 class="ql-align-center">Getting Started is Easy</h2>
                      <p><br></p>
                      <pre>// &lt;link href="https://cdn.quilljs.com/1.0.5/quill.snow.css" rel="stylesheet"&gt;
	// &lt;script src="https://cdn.quilljs.com/1.0.5/quill.min.js" type="text/javascript"&gt;&lt;/script&gt;
	var quill = new Quill('#editor', {
	modules: {
		toolbar: '#toolbar'
	},
	theme: 'snow'
	});
	// Open your browser's developer console to try out the API!
											</pre>
                      <p><br></p>
                      <p><br></p>
                      <p class="ql-align-center"><strong>Built with</strong></p>
                      <p class="ql-align-center">&nbsp;<span class="ql-formula"
                          data-value="x^2 + (y - \sqrt[3]{x^2})^2 = 1"></span>&nbsp;</p>
                      <p><br></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Snow Editor end -->


<!-- Bubble Editor start -->
<section class="quill-editor">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Bubble Editor</h4>
        </div>
        <div class="card-content collapse show">
          <div class="card-body">
            <p><code>Bubble</code> is a simple tooltip based theme. Try double clicking on text, you should see bubble
              with toolbars for editing.</p>
            <div class="row">
              <div class="col-sm-12">
                <div id="bubble-wrapper">
                  <div id="bubble-container">
                    <div class="editor">
                      <h1 class="ql-align-center">Quill Rich Text Editor</h1>
                      <p><br></p>
                      <p>Quill is a free, <a href="https://github.com/quilljs/quill/">open source</a> WYSIWYG editor
                        built for the modern web. With its <a href="http://quilljs.com/docs/modules/">modular
                          architecture</a> and expressive <a href="http://quilljs.com/docs/api/">API</a>, it is
                        completely customizable to fit any need.</p>
                      <p><br></p>
                      <iframe class="ql-video ql-align-center"
                        src="https://www.youtube.com/embed/QHH3iSeDBLo?showinfo=0" width="560" height="238"></iframe>
                      <p><br></p>
                      <p><br></p>
                      <h2 class="ql-align-center">Getting Started is Easy</h2>
                      <p><br></p>
                      <pre class="language-javascript">
<code class="language-javascript">
    // &lt;link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet"&gt;
    // &lt;script src="https://cdn.quilljs.com/1.3.6/quill.min.js" type="text/javascript"&gt;&lt;/script&gt;
    var quill = new Quill('#editor', {
    modules: {
      toolbar: '#toolbar'
    },
    theme: 'snow'
    });
    // Open your browser's developer console to try out the API!

</code>
                      </pre>
                      <p><br></p>
                      <p><br></p>
                      <p class="ql-align-center"><strong>Built with</strong></p>
                      <p class="ql-align-center">&nbsp;<span class="ql-formula"
                          data-value="x^2 + (y - \sqrt[3]{x^2})^2 = 1"></span>&nbsp;</p>
                      <p><br></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Bubble Editor end -->

<!-- full Editor start -->
<section class="full-editor">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Full Editor</h4>
        </div>
        <div class="card-content collapse show">
          <div class="card-body">
            <p>By default all formats are enabled and allowed to exist within a Quill editor and can be configured with
              the <code>formats</code> option. This is separate from adding a control in the <code>Toolbar</code>. For
              example, you can configure Quill to allow bolded content to be pasted into an editor that has no bold
              button in the toolbar.</p>
            <div class="row">
              <div class="col-sm-12">
                <div id="full-wrapper">
                  <div id="full-container">
                    <div class="editor">
                      <h1 class="ql-align-center">Quill Rich Text Editor</h1>
                      <p><br></p>
                      <p>Quill is a free, <a href="https://github.com/quilljs/quill/">open source</a> WYSIWYG editor
                        built for the modern web. With its <a href="http://quilljs.com/docs/modules/">modular
                          architecture</a> and expressive <a href="http://quilljs.com/docs/api/">API</a>, it is
                        completely customizable to fit any need.</p>
                      <p><br></p>
                      <iframe class="ql-video ql-align-center"
                        src="https://www.youtube.com/embed/QHH3iSeDBLo?showinfo=0" width="560" height="238"></iframe>
                      <p><br></p>
                      <p><br></p>
                      <h2 class="ql-align-center">Getting Started is Easy</h2>
                      <p><br></p>
                      <pre>// &lt;link href="https://cdn.quilljs.com/1.0.5/quill.snow.css" rel="stylesheet"&gt;
	// &lt;script src="https://cdn.quilljs.com/1.0.5/quill.min.js" type="text/javascript"&gt;&lt;/script&gt;
	var quill = new Quill('#editor', {
	modules: {
		toolbar: '#toolbar'
	},
	theme: 'snow'
	});
	// Open your browser's developer console to try out the API!
											</pre>
                      <p><br></p>
                      <p><br></p>
                      <p class="ql-align-center"><strong>Built with</strong></p>
                      <p class="ql-align-center">&nbsp;<span class="ql-formula"
                          data-value="x^2 + (y - \sqrt[3]{x^2})^2 = 1"></span>&nbsp;</p>
                      <p><br></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- full Editor end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
        <!-- vednor files -->
        <script src="<?php echo e(asset(mix('vendors/js/editors/quill/katex.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/editors/quill/highlight.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/editors/quill/quill.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/extensions/jquery.steps.min.js'))); ?>"></script>
        <script src="<?php echo e(asset(mix('vendors/js/forms/validation/jquery.validate.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('myscript'); ?>
        <!-- Page js files -->
        <script src="<?php echo e(asset(mix('js/scripts/editors/editor-quill.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\vuesax-bootstrap-laravel-admin-template\resources\views//pages/ext-component-quill-editor.blade.php ENDPATH**/ ?>